import plus
import random
from AI import vector3

import Arenas

class Hazard(object):
    def __init__(self, location):
        self.location = location

class Flames(Hazard):

    def __init__(self, location = (0, 0, 0), velocity = (0, 0, 0), variance = (0, 0, 0), yOffset = 0):
        Hazard.__init__(self, location)
        self.refcount = 0
        self.velocity = velocity
        self.variance = variance
        self.emitter = plus.AddParticleEmitter(self.location, self.velocity, self.variance)
        self.emitting = False
        self.timeEmitting = 0
        self.adjustedLoc = vector3(self.location)
        self.adjustedLoc.y += yOffset
        self.flamesound = plus.createSound("Sounds/flame_throwerquiet.wav", True, self.location)
        
    def __del__(self):
        plus.removeSound(self.flamesound)
        
    def Tick(self):
        if self.emitting==True:
            if plus.isMatchOver():
                self.FlameOff()
                
            if self.timeEmitting<1:     #flames are long enough by the end of 1 second
                self.timeEmitting += .25
            
            vel = vector3(self.velocity)
            flamepos = vel * self.timeEmitting
            flamepos = flamepos + vector3(self.location)
            arena = Arenas.currentArena
            if arena:
                compinfo = plus.rayTest(self.adjustedLoc.asTuple(), flamepos.asTuple())
                if not compinfo[0]==-1:  # we got a valid bot and component back from the ray test
                    if not plus.isMatchPaused() and not plus.isMatchOver():
                        plus.damage(compinfo[0], compinfo[1], 30, (compinfo[2], compinfo[3], compinfo[4]))
    
    def FlameOff(self):
        self.emitter.SetEmitting(False)
        self.emitting = False
        plus.stopSound(self.flamesound)
    
    def FlameOn(self):
        self.emitter.SetEmitting(True)
        self.emitting = True
        plus.loopSound(self.flamesound)
        self.timeEmitting = 0
    
    def ZoneEvent(self, direction):
        if direction==1:
            self.refcount+= 1
            if self.refcount == 1:
                self.FlameOn()
        elif direction==-1:
            self.refcount -= 1
            if self.refcount == 0:
                self.FlameOff()

class Saws(Hazard):

    def __init__(self, a_prismatic, location = (0, 0, 0)):
        Hazard.__init__(self, location)
        #statuses: 0=off, 1=on
        self.status = 0
        self.prismatic = a_prismatic
        self.prismatic.SetAutoLock(False)
        self.prismatic.SetPowerSettings(.1, -150000)
        self.timer = 0
        self.refcount = 0
	self.moved = 0
	self.prismatic.Lock(True)
        self.slidesound = plus.createSound("Sounds\\hzd_trapdoor_loop.wav", True, self.location)

    def __del__(self):
        plus.removeSound(self.slidesound)


    def ZoneEvent(self, direction):
        if direction ==1:
		self.refcount += 1
		self.MoveSaw(1)
 		self.status = 1
	    
	elif direction == -1:
        	self.refcount -= 1
	   
    def Tick(self):
        if self.status == 1:
	    self.timer += .5
	    if self.timer == 10: self.StopSaw(0)
            
    def MoveSaw(self, dir):
	if self.moved ==0:
	    self.status = 1
	    self.moved = 1
            self.prismatic.Lock(False)
            self.prismatic.SetDirection(dir)
	    plus.loopSound(self.slidesound)

    def StopSaw(self, dir):
	self.status = 0
        self.prismatic.SetDirection(0)
        #self.prismatic.Lock(True)
        plus.stopSound(self.slidesound)

